--noise example by dave1707

function setup()
    assert(craft, "Please include Craft as a dependency")
    assert(OrbitViewer, "Please include Cameras (not Camera) as a dependency")
    tab={}
    scene = craft.scene()
    skyMaterial=scene.sky.material
    skyMaterial.sky=color(0)
    skyMaterial.horizon=color(0)
    scene.sun.rotation=quat.eulerAngles(20,45,-30)
    v=scene.camera:add(OrbitViewer, vec3(0,0,0), 50, 0, 300)
    v.rx=10
    v.ry=20
    calc()
end

function createSphere(x,y,z,val)
    size=.2
    sphere1=scene:entity()
    s1=sphere1:add(craft.rigidbody,STATIC)
    sphere1.position=vec3(x*2,y*2,z*2)
    sphere1:add(craft.shape.sphere,size)
    sphere1.model = craft.model.icosphere(size,3)
    sphere1.material = craft.material("Materials:Specular")
    setColor(val)
    sphere1.material.diffuse=color(r,g,b)
    table.insert(tab,sphere1)
end

function setColor(v)
    if v<-.9 then
        r,g,b=0,0,0
    elseif v<-.6 then
        r,g,b=0,0,255
    elseif v<-.3 then
        r,g,b=0,255,0
    elseif v<0 then
        r,g,b=0,255,255
    elseif v>.9 then
        r,g,b=255,255,255
    elseif v>.6 then
        r,g,b=255,255,0
    elseif v>.3 then
        r,g,b=255,0,255
    elseif v>=0 then
        r,g,b=255,0,0
    end
end

function draw()
    update(DeltaTime)
    scene:draw()    
    text("Slide your finger to rotate image",WIDTH/2,HEIGHT-25)
    text("Two finger pinch or expand or move to zoom in or out or move.",WIDTH/2,HEIGHT-50)
    fill(94, 182, 229, 255)
    rect(0,425,80,200)
    fill(0,0,0)
    text("-1 to -.9",40,600)
    fill(0,0,255)
    text("-.9 to -.6",40,580)
    fill(0,255,0)
    text("-.6 to -.3",40,560)
    fill(0,255,255)
    text("-.3 to   0",40,540)
    fill(255,0,0)
    text("  0 to  .3",40,520)
    fill(255,0,255)
    text(" .3 to  .6",40,500)
    fill(255,255,0)
    text(" .6 to  .9",40,480)
    fill(255,255,255)
    text(" .9 to   1",40,460)
end

function update(dt)
    scene:update(dt)
end

function calc()
    tab={}
    step=.2
    n=craft.noise.perlin()
    --n=craft.noise.billow()
    for x=-1.2,1.2, step do
        for y=-1.2,1.2,step do
            for z=-1.2,1.2,step do
                value = n:getValue(x,y,z)
                createSphere(x*5,y*5,z*5,value)
            end
        end
    end
end